--PERCENT_RANK and CUME_DIST
--Window frame not supported
/*
PERCENT_RANK = My score is higher than 89% of the scores
CUME_DIST = My score is at 90%
*/
USE test;
GO
BEGIN TRY 
	DROP Table MonthlyTempsSTL
END TRY
BEGIN CATCH 
END CATCH;

CREATE TABLE MonthlyTempsStl(MNo Int, MName varchar(15), AvgHighTemp INT)

INSERT INTO MonthlyTempsStl
VALUES(1,'Jan',40),(2,'Feb',45),(3,'Mar',55),(4,'Apr',67),(5,'May',77),(6,'Jun',85),
	(7,'Jul',89),(8,'Aug',88),(9,'Sep',81),(10,'Oct',69),(11,'Nov',56),(12,'Dec',43)

SELECT MName, AvgHighTemp, RANK() OVER(ORDER BY AvgHighTemp) AS Rnk,
	PERCENT_RANK() OVER(ORDER BY AvgHighTemp) * 100.0 AS PercentRank,
	CUME_DIST() OVER(ORDER BY AvgHighTemp) * 100.0 AS CumeDist
FROM MonthlyTempsStl;



Use AdventureWorks2014;
GO

SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS OrderMonth,
     PERCENT_RANK() OVER(ORDER BY COUNT(*)) * 100 AS PercentRank,
	 CUME_DIST() OVER(ORDER BY COUNT(*)) * 100 AS CumeDist
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31' 
GROUP BY  Month(OrderDate);

--This is the same thing!!
SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS OrderMonth,
	((RANK() OVER(ORDER BY COUNT(*)) -1) * 100.0)/(COUNT(*) OVER() -1) AS PR,
	(RANK() OVER(ORDER BY COUNT(*)) * 100.0)/COUNT(*) OVER() AS CD
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31'
GROUP BY  Month(OrderDate);


--PERCENTILE_CONT and PERCENTILE_DISC
--Window frame not supported
/*
Find the value at a particular rank. Percentile_Cont will return
a calculated value. Percentile_disc will return an exact value

PERCENTILE_CONT ( numeric_literal ) 
    WITHIN GROUP ( ORDER BY order_by_expression [ ASC | DESC ] )
    OVER ( [ <partition_by_clause> ] )


*/
SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS orderMonth,
	PERCENTILE_CONT(.5) WITHIN GROUP (ORDER BY COUNT(*)) 
		OVER() AS PercentileCont,
	PERCENTILE_DISC(.5) WITHIN GROUP (ORDER BY COUNT(*)) 
		OVER() AS PercentileDisc
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31' 
GROUP BY Month(OrderDate); 


--PERCENTILE_CONT and PERCENTILE_DISC
--Window frame not supported
/*
Find the value at a particular rank. Percentile_Cont will return
a calculated value. Percentile_disc will return an exact value
This is the same as Median when using 0.5!
*/
SELECT COUNT(*) NumberOfOrders, Month(OrderDate) AS orderMonth,
	PERCENTILE_CONT(.5) WITHIN GROUP (ORDER BY COUNT(*)) 
		OVER() AS PercentileCont,
	PERCENTILE_DISC(.5) WITHIN GROUP (ORDER BY COUNT(*)) 
		OVER() AS PercentileDisc
FROM Sales.SalesOrderHeader
WHERE OrderDate BETWEEN '2013-01-01' AND '2013-12-31' 
GROUP BY Month(OrderDate); 



	


 

